# Jujutsu VCS Plugin for JetBrains IDEs

## Project Overview

This plugin provides Jujutsu (jj) version control system integration for JetBrains IDEs, leveraging the existing IntelliJ Platform VCS framework (`com.intellij.vcs` and related APIs).

## Goals

- **Native Integration**: Seamlessly integrate with IntelliJ's VCS UI components and workflows
- **Feature Parity**: Provide core jj operations through familiar IDE interfaces
- **Cross-IDE Support**: Work across all JetBrains IDEs (IntelliJ IDEA, PyCharm, WebStorm, etc.)
- **Version Compatibility**: Support IntelliJ 2024.x - 2025.1.3+

## Key Components

### VCS Integration Points
- **AbstractVcs**: Main VCS provider implementation
- **VcsRoot**: Repository detection and management
- **ChangeProvider**: Track working copy changes
- **CheckinEnvironment**: Commit operations
- **UpdateEnvironment**: Update/sync operations
- **AnnotationProvider**: Blame/annotate functionality
- **HistoryProvider**: Log and revision history
- **DiffProvider**: Change visualization

### Jujutsu-Specific Features
- **Change/Revision Model**: Map jj's change-based model to IntelliJ's commit model
- **Working Copy Management**: Handle jj's working copy concept
- **Branch/Bookmark Support**: Integrate with jj's bookmark system
- **Conflict Resolution**: Leverage jj's advanced conflict handling

## Technical Approach

- **Kotlin**: Primary development language
- **IntelliJ Platform SDK**: 2024.x baseline with 2025.1.3 target
- **JJ CLI Integration**: Execute jujutsu commands via process execution
- **JSON/Templating**: Use jj's template system for structured data retrieval

## Architecture Principles

- Reuse existing IntelliJ VCS UI components wherever possible
- Minimize custom UI development
- Follow IntelliJ Platform patterns and conventions
- Graceful degradation for unsupported jj features

## Release Roadmap

### v1.0 - Core Functionality (Initial Release)

**Essential Features:**
- **Repository Detection**: Automatically detect existing jj repositories and register VCS roots
  - Supports repos created via `jj init`, `jj git init`, etc.
  - Users initialize repos externally (v1.0 scope limitation)
- **File Status Tracking**: Show modified/added/deleted files in Changes view and file tree
- **Basic Commit Operations**: Create new changes via standard commit dialog
- **Diff Visualization**: View file differences using IntelliJ's built-in diff viewer
- **Change History**: Browse change history with basic log view
- **Working Copy Status**: Show current working copy state and conflicts

**Success Criteria:**
- Users can perform daily development workflows (edit → commit → view history)
- File status indicators work correctly across all JetBrains IDEs
- No major performance issues with large repositories

### v1.1 - Branch Operations

- **Bookmark Management**: Create, switch, and delete bookmarks
- **Branch Operations**: Basic branch creation and switching
- **Remote Operations**: Push/pull with remote repositories

### v1.2 - Advanced Features

- **Conflict Resolution**: Enhanced UI for resolving merge conflicts
- **Annotate/Blame**: Show change history for individual lines
- **Rebase Operations**: Interactive rebase and change manipulation
- **Evolution Integration**: Support for jj's change evolution features

### Future Considerations

- **Custom UI Components**: Jujutsu-specific views for advanced workflows
- **Performance Optimization**: Caching and async operations for large repos
- **Advanced Templating**: Leverage jj's templating for custom views