/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.ibm.icu.util.StringTokenizer
import com.intellij.ide.AppLifecycleListener
import com.intellij.openapi.application.ApplicationManager
import com.intellij.openapi.application.WriteAction
import com.intellij.openapi.diagnostic.logger
import com.intellij.openapi.fileTypes.FileTypeManager

private val LOG = logger<AddIgnoreJJDirSetting>()

class AddIgnoreJJDirSetting : AppLifecycleListener {
    // I've overriding this because the project listener or appStarted are both called after the project is already loaded.
    // Hiding the .jj dir at that point causes a re-index if it wasn't already hidden.
    // Could revisit if the perf impact is a real issue.
    override fun appFrameCreated(commandLineArgs: List<String?>) {
        ApplicationManager.getApplication().invokeLater {
            WriteAction.run<RuntimeException> {
                val manager = FileTypeManager.getInstance()
                val ignoredFilesList = manager.ignoredFilesList

                // Check if .jj is already in the list
                val tokenizer = StringTokenizer(ignoredFilesList, ";")
                while (tokenizer.hasMoreTokens()) {
                    val token = tokenizer.nextToken()
                    if (token.equals(".jj", ignoreCase = true)) {
                        LOG.debug(".jj already in ignored files list")
                        return@run
                    }
                }

                manager.ignoredFilesList = "$ignoredFilesList;.jj"
            }
        }
    }
}
