/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.openapi.vcs.history.VcsRevisionNumber

class SelvejjRevisionNumber(private val commitId: String) : VcsRevisionNumber {

    override fun asString(): String = commitId

    override fun compareTo(other: VcsRevisionNumber?): Int {
        if (other !is SelvejjRevisionNumber) return 0
        return commitId.compareTo(other.commitId)
    }

    fun getCommitId(): String = commitId

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other !is SelvejjRevisionNumber) return false
        return commitId == other.commitId
    }

    override fun hashCode(): Int = commitId.hashCode()

    override fun toString(): String = commitId
}