/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj.actions

import com.intellij.openapi.actionSystem.AnAction
import com.intellij.openapi.vcs.annotate.AnnotationGutterActionProvider
import com.intellij.openapi.vcs.annotate.FileAnnotation
import com.selvejj.SelvejjAnnotation

/**
 * Provides custom actions for the annotation gutter context menu.
 * This adds a "Copy Change ID" action for Selvejj annotations.
 */
class SelvejjAnnotationGutterActionProvider : AnnotationGutterActionProvider {
    override fun createAction(annotation: FileAnnotation): AnAction {
        return CopyChangeIdFromAnnotateAction(annotation)
    }
}
