/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.execution.configurations.GeneralCommandLine
import com.intellij.execution.util.ExecUtil
import org.junit.After
import org.junit.Assert.assertTrue
import org.junit.Before
import org.junit.Test
import java.io.File
import java.nio.file.Files

class SelvejjVcsRootCheckerTest {

    private lateinit var repoDir: File

    @Before
    fun setUp() {
        // Create a temporary directory
        repoDir = Files.createTempDirectory("selvejj-test").toFile()
    }

    @After
    fun tearDown() {
        // Clean up
        repoDir.deleteRecursively()
    }

    @Test
    fun testIsRootReturnsTrueForJjRepository() {
        // Initialize a jj repository
        val commandLine = GeneralCommandLine("jj")
            .withParameters("git", "init")
            .withWorkDirectory(repoDir)
        val result = ExecUtil.execAndGetOutput(commandLine, 10000)
        assertTrue("jj git init should succeed", result.exitCode == 0)

        // Verify .jj directory was created
        val jjDir = File(repoDir, ".jj")
        assertTrue(".jj directory should exist", jjDir.exists() && jjDir.isDirectory)

        // Test isRoot()
        val checker = SelvejjVcsRootChecker()
        assertTrue("isRoot() should return true for jj repository root", checker.isRoot(repoDir.absolutePath))
    }
}
