## Project Overview

Selvejj is an IntelliJ Platform plugin that provides first-class integration of the Jujutsu (jj) version control system
into JetBrains IDEs. It enables developers to perform daily VCS workflows (editing, committing, viewing history) using
familiar IDE interfaces instead of command-line tools.

**Current Version**: 0.3.0 (supports committing individual hunks)
**Goal**: Achieve feature parity with Git integration for core workflows by v1.0

## Key Technologies & Platforms

- **IntelliJ Platform SDK**: 2024.2 baseline, targeting 2024.x - 2025.1.3+
- **Language**: Kotlin (100% Kotlin codebase)
- **JVM Target**: Java 21
- **Build System**: Gradle with Kotlin DSL
- **VCS Integration**: jj CLI via process execution with template-based parsing

## Core Components

- SelvejjVcs: Main VCS provider (AbstractVcs implementation)
- SelvejjChangeProvider: File status tracking and change detection
- SelvejjCheckinEnvironment: Commit operations with partial commit support
- SelvejjVcsLogProvider: Change history and log visualization
- SelvejjVcsRootChecker: Repository detection and management
- Custom actions for jj-specific operations (e.g., copy change IDs)

## Repository Context

- We are in a jj (Jujutsu) repository
- Prefer meaningful, insightful commit messages that add value beyond what is obvious from the code changes

## Development Environment

- You can find intellij platform sources applicable to this project at ~/ij-sources-for-claude
- If you need to write tests, read @TESTING_GUIDE.md