import org.jetbrains.intellij.platform.gradle.IntelliJPlatformType
import org.jetbrains.kotlin.gradle.dsl.JvmTarget

plugins {
    id("java")
    id("org.jetbrains.kotlin.jvm") version "2.1.0"
    id("org.jetbrains.kotlin.plugin.serialization") version "2.1.0"
    id("org.jetbrains.intellij.platform") version "2.5.0"
}

group = "com.selvejj"
// Remember to also update changeNotes below when changing this :/
version = "0.4.1"

repositories {
    mavenCentral()
    intellijPlatform {
        defaultRepositories()
    }
}

// Configure Gradle IntelliJ Plugin
// Read more: https://plugins.jetbrains.com/docs/intellij/tools-intellij-platform-gradle-plugin.html
dependencies {
    // This is marked compileOnly because the runtime lib is shipped with IJ.
    // To figure out which IJ version ships with which version of kotlinx-serialization
    // https://www.jetbrains.com/legal/third-party-software/ is the best place.
    compileOnly("org.jetbrains.kotlinx:kotlinx-serialization-json:1.6.2")

    intellijPlatform {
        create("IC", "2024.2")
        testFramework(org.jetbrains.intellij.platform.gradle.TestFrameworkType.Starter)
        bundledPlugin("Git4Idea")
    }

    testImplementation("org.junit.jupiter:junit-jupiter-api:5.10.2")
    testRuntimeOnly("org.junit.jupiter:junit-jupiter-engine:5.10.2")
    testImplementation("org.kodein.di:kodein-di-jvm:7.20.2")
}

intellijPlatform {
    pluginConfiguration {
        ideaVersion {
            sinceBuild = "242"
            untilBuild = provider { null }
        }
        changeNotes = """
            v0.4.1
            ------
            * Fixed a bug with escaping Windows paths in the change provider.
            * Fixed an out-of-bounds access in the annotations view.
            * Use dirty scopes where necessary, instead of the project base path.
    """.trimIndent()
    }

    pluginVerification {
        ides {
            ide(IntelliJPlatformType.IntellijIdeaCommunity, "2024.2")
        }
    }

    publishing {
        token = providers.gradleProperty("intellijPlatformPublishingToken")
        channels = listOf(providers.gradleProperty("intellijPlatformPublishingChannel").getOrElse("development"))
    }
}

tasks {
    // Set the JVM compatibility versions
    withType<JavaCompile> {
        sourceCompatibility = "21"
        targetCompatibility = "21"
    }
    withType<org.jetbrains.kotlin.gradle.tasks.KotlinCompile> {
        compilerOptions.jvmTarget.set(JvmTarget.JVM_21)
    }

    test {
        dependsOn("buildPlugin")
        systemProperty(
            "path.to.build.plugin",
            named<Zip>("buildPlugin").get().archiveFile.get().asFile.absolutePath
        )
        useJUnitPlatform()
    }
}
