/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.execution.configurations.GeneralCommandLine
import com.intellij.execution.util.ExecUtil
import com.intellij.openapi.diagnostic.logger
import com.intellij.openapi.vcs.FilePath
import com.intellij.openapi.vcs.changes.ContentRevision
import com.intellij.openapi.vcs.history.VcsRevisionNumber

class SelvejjHistoricalContentRevision(
    private val filePath: FilePath,
    private val revisionNumber: VcsRevisionNumber,
    private val repositoryRoot: String,
    private val relativePath: String
) : ContentRevision {

    companion object {
        private val LOG = logger<SelvejjHistoricalContentRevision>()
    }

    override fun getContent(): String? {
        val commitId = (revisionNumber as SelvejjRevisionNumber).getCommitId()

        val command = GeneralCommandLine("jj")
            .withParameters("file", "show", "-r", commitId, relativePath)
            .withWorkDirectory(repositoryRoot)

        val result = ExecUtil.execAndGetOutput(command, 10000)
        return if (result.checkSuccess(LOG)) result.stdout else {
            LOG.warn("Failed to get file content for ${relativePath} at ${revisionNumber.asString()}: ${result.stderr}")
            null
        }
    }


    override fun getFile(): FilePath = filePath

    override fun getRevisionNumber(): VcsRevisionNumber = revisionNumber
}