/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.dvcs.DvcsRememberedInputs
import com.intellij.openapi.application.ApplicationManager
import com.intellij.openapi.components.PersistentStateComponent
import com.intellij.openapi.components.RoamingType
import com.intellij.openapi.components.State
import com.intellij.openapi.components.Storage

/**
 * Service for remembering JJ clone inputs (URLs and directories)
 */
@State(
    name = "SelvejjRememberedInputs",
    storages = [
        Storage(value = "vcs.xml", deprecated = true),
        Storage(value = "vcs-inputs.xml", roamingType = RoamingType.DISABLED)
    ]
)
class SelvejjRememberedInputs : DvcsRememberedInputs(), PersistentStateComponent<DvcsRememberedInputs.State> {

    companion object {
        @JvmStatic
        fun getInstance(): DvcsRememberedInputs {
            return ApplicationManager.getApplication().getService(DvcsRememberedInputs::class.java)
        }
    }
}