/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import java.util.EventListener

/**
 * Listener for changes in Jujutsu repositories.
 * Subscribers will be notified when a repository's state changes.
 */
interface SelvejjRepositoryChangeListener : EventListener {
    /**
     * Called when a repository's state has changed.
     * @param repository The repository that has changed.
     */
    fun repositoryChanged(repository: SelvejjRepository)
}