/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.dvcs.repo.Repository
import com.intellij.dvcs.repo.VcsRepositoryCreator
import com.intellij.openapi.Disposable
import com.intellij.openapi.project.Project
import com.intellij.openapi.vcs.VcsKey
import com.intellij.openapi.vfs.VirtualFile
import java.io.File

/**
 * Creator for Jujutsu repositories.
 * Checks if a directory is a valid Jujutsu repository and creates a SelvejjRepository instance if it is.
 */
class SelvejjRepositoryCreator : VcsRepositoryCreator {

    /**
     * Returns the VCS key for Jujutsu.
     */
    override fun getVcsKey(): VcsKey {
        return SelvejjVcs.getKey()
    }

    /**
     * Creates a SelvejjRepository instance if the given directory is a valid Jujutsu repository.
     * @param project The project
     * @param root The root directory of the repository
     * @param parentDisposable The parent disposable
     * @return A SelvejjRepository instance if the directory is a valid Jujutsu repository, null otherwise
     */
    override fun createRepositoryIfValid(
        project: Project,
        root: VirtualFile,
        parentDisposable: Disposable
    ): Repository? {
        val jjDir = File(root.path, ".jj")
        if (jjDir.exists() && jjDir.isDirectory) {
            val repository = SelvejjRepository(project, root, parentDisposable)
            repository.setupUpdater()
            return repository
        }
        return null
    }
}