/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj

import com.intellij.execution.configurations.GeneralCommandLine
import com.intellij.execution.util.ExecUtil
import com.intellij.openapi.diagnostic.logger
import com.intellij.openapi.vcs.VcsKey
import com.intellij.openapi.vcs.VcsRootChecker
import java.nio.file.Paths

class SelvejjVcsRootChecker : VcsRootChecker() {

    companion object {
        private val LOG = logger<SelvejjVcsRootChecker>()
    }

    override fun isRoot(path: String): Boolean {
        return try {
            val actualRoot = runJjCommand(path, "workspace", "root")
            actualRoot != null && Paths.get(actualRoot).normalize() == Paths.get(path).normalize()
        } catch (e: Exception) {
            LOG.warn("Failed to check if path is jj root: $path", e)
            false
        }
    }

    override fun getSupportedVcs(): VcsKey {
        return SelvejjVcs.getKey()
    }

    override fun isVcsDir(dirName: String): Boolean {
        // Check if this directory is a .jj directory
        return dirName == ".jj"
    }

    private fun runJjCommand(workingDir: String, vararg args: String): String? {
        val commandLine = GeneralCommandLine("jj")
            .withParameters(args.toList())
            .withWorkDirectory(workingDir)
        val result = ExecUtil.execAndGetOutput(commandLine, 5000)
        return if (result.checkSuccess(LOG)) result.stdout.trim() else null
    }
}
