/*
 * Copyright (c) 2025 Nikhil Marathe <nikhil@selvejj.com>
 */

package com.selvejj.checkout

import com.intellij.openapi.application.ModalityState
import com.intellij.openapi.project.Project
import com.intellij.openapi.vcs.CheckoutProvider
import com.intellij.openapi.vcs.CheckoutProviderEx
import com.intellij.openapi.vcs.ui.VcsCloneComponent
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener

/**
 * Checkout provider for Jujutsu (jj) VCS that enables cloning repositories in the new project dialog
 */
class SelvejjCheckoutProvider : CheckoutProviderEx() {

    override fun getVcsId(): String = "jj"

    override fun getVcsName(): String = "Jujutsu (Git backend only)"

    @Deprecated("Deprecated in Java")
    override fun doCheckout(project: Project, listener: CheckoutProvider.Listener?) {
        // This method is deprecated and should not be used
        // Implementation is handled by buildVcsCloneComponent
    }

    @Deprecated("Deprecated in Java")
    override fun doCheckout(project: Project, listener: CheckoutProvider.Listener?, predefinedRepositoryUrl: String?) {
        // This method is deprecated and should not be used
        // Implementation is handled by buildVcsCloneComponent
    }

    override fun buildVcsCloneComponent(
        project: Project,
        modalityState: ModalityState,
        dialogStateListener: VcsCloneDialogComponentStateListener
    ): VcsCloneComponent {
        return com.selvejj.ui.SelvejjCloneDialogComponent(project, dialogStateListener)
    }
}